#include "LabFrameFIR.h"


#define N 401		    // number of filter coefficients
section("L1_data_b") fract16 coefs[N] = {
#include "bp_fract16.dat"
};

/*
#define N 4800		    // number of filter coefficients
fract16 coefs[N] = {
#include "mova_fract16.dat"
};
*/
/*
#define N 4		    // number of filter coefficients
fract16 coefs[N] = {

0x1000,
0x1000,
0x1000,
0x1000
};
*/

section("L1_data_a") fract16 input[N];
fract16 output[N];
int i = 0;		

extern int conv_asm( fract16 *, fract16 *, fract16 * );

//--------------------------------------------------------------------------//
// Function:	Process_Data()												//
//																			//
// Description: This function is called from inside the SPORT0 ISR every 	//
//				time a complete audio frame has been received. The new 		//
//				input samples can be found in the variables iChannel0LeftIn,//
//				iChannel0RightIn, iChannel1LeftIn and iChannel1RightIn 		//
//				respectively. The processed	data should be stored in 		//
//				iChannel0LeftOut, iChannel0RightOut, iChannel1LeftOut,		//
//				iChannel1RightOut, iChannel2LeftOut and	iChannel2RightOut	//
//				respectively.												//
//--------------------------------------------------------------------------//
void Process_Data(void)
{	
	
	iChannel0LeftOut = iChannel0RightIn;	// Talk through
				
	input[i] = iChannel0RightIn >> 8;		
			
	fract16 out = 0;
			
	// Filter loop		
	out = conv_asm(coefs,&input[i],input);		
	output[i++] = out;
	
	if (i==N){
		i = 0;	
	}
	
	iChannel0RightOut = out <<8;					
}

