#include "LabFrameFIR.h"

#define N 20		// number of filter coefficients
float coefs[N] = {	// Filter coeffs
#include "mova_float.dat"
};



float input[N];
int output[N];
int i = 0;		

//--------------------------------------------------------------------------//
// Function:	Process_Data()												//
//																			//
// Description: This function is called from inside the SPORT0 ISR every 	//
//				time a complete audio frame has been received. The new 		//
//				input samples can be found in the variables iChannel0LeftIn,//
//				iChannel0RightIn, iChannel1LeftIn and iChannel1RightIn 		//
//				respectively. The processed	data should be stored in 		//
//				iChannel0LeftOut, iChannel0RightOut, iChannel1LeftOut,		//
//				iChannel1RightOut, iChannel2LeftOut and	iChannel2RightOut	//
//				respectively.												//
//--------------------------------------------------------------------------//
// The function below is capable to execute an FIR filter up to 10 (!)      //
// coefficents only.                                                        //
//--------------------------------------------------------------------------//

void Process_Data(void)
{
	
	iChannel0LeftOut = iChannel0RightIn;	
		
	iChannel0RightIn = iChannel0RightIn <<8;
	input[i] = (float) iChannel0RightIn;	

				
	int j;
	int ix = i;
	float fout = 0;
	int out;		
	
	// Filter loop
	for (j=0;j<N;j++){
		fout += input[ix++%N] * coefs[j]; 
	}
	
	out = (int) fout;				
	output[i++] = out;	
	
	if (i==N)
	{
		i = 0;
	}
	
	iChannel0RightOut = out >> 8;	
	
}

