/* =============================================================================
 *
 *  Description: This is a C++ implementation for Thread input_read
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

#include "input_read.h"
#include <new>
#include "msg.h"

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

/******************************************************************************
 *  input_read Run Function (input_read's main{})
 */
 
typedef short SampleWord;
#define SAMPLEPAIRS_PER_BUFFER 48

 
void
input_read::Run()
{
    // TODO - Put the thread's "main" Initialization HERE
	VDK::DeviceDescriptor dd = VDK::OpenDevice(kADC0, "R16"); // open for reading
	
	void *pBuffer1 = new SampleWord[2*SAMPLEPAIRS_PER_BUFFER];    
    void *pBuffer2 = new SampleWord[2*SAMPLEPAIRS_PER_BUFFER];    
    unsigned char current_buffer = 1;

 	VDK::MessageID msg1 = VDK::CreateMessage(1, SAMPLEPAIRS_PER_BUFFER, pBuffer1);   
 	VDK::MessageID msg2 = VDK::CreateMessage(1, SAMPLEPAIRS_PER_BUFFER, pBuffer2);   
    VDK::SyncRead(dd, (char*) pBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
    while (1)
    {
        // TODO - Put the thread's "main" body HERE
		if(1 == current_buffer)
		{
        	VDK::SyncRead(dd, (char*) pBuffer2, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
        	current_buffer = 2;
        	VDK::PostMessage(kmt, msg1, INPUT_DATA_CHANNEL);
        	msg1 = VDK::PendMessage(INPUT_DATA_BACKCHANNEL, 0);
		}
		else
		{
        	VDK::SyncRead(dd, (char*) pBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
        	current_buffer = 1;
        	VDK::PostMessage(kmt, msg2, INPUT_DATA_CHANNEL);
        	msg2 = VDK::PendMessage(INPUT_DATA_BACKCHANNEL, 0);
		}
		
        // Use a "break" instruction to exit the "while (1)" loop
    }

    // TODO - Put the thread's exit from "main" HERE
	// A thread is automatically Destroyed when it exits its run function
}

/******************************************************************************
 *  input_read Error Handler
 */
 
int
input_read::ErrorHandler()
{
    /* TODO - Put this thread's error handling code HERE */

    /* The default ErrorHandler (called below)  raises
     * a kernel panic and stops the system */
    return (VDK::Thread::ErrorHandler());
}

/******************************************************************************
 *  input_read Constructor
 */
 
input_read::input_read(VDK::Thread::ThreadCreationBlock &tcb)
    : VDK::Thread(tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    // TODO - Put code to be executed when this thread has just been created HERE
    m_main_thread = kmt;

}

/******************************************************************************
 *  input_read Destructor
 */
 
input_read::~input_read()
{
    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */

    // TODO - Put code to be executed just before this thread is destroyed HERE

}

/******************************************************************************
 *  input_read Externally Accessible, Pre-Constructor Create Function
 */
 
VDK::Thread*
input_read::Create(VDK::Thread::ThreadCreationBlock &tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    	return new (tcb) input_read(tcb);
}

/* ========================================================================== */
