/* =============================================================================
 *
 *  Description: This is a C++ implementation for Thread main_thread
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

#include "main_thread.h"
#include <new>
#include <stdio.h>
#include "msg.h"
#include "volcalc.h"
#include "globals.h"

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

#define SAMPLEPAIRS_PER_BUFFER 48

/******************************************************************************
 *  main_thread Run Function (main_thread's main{})
 */
 
void
main_thread::Run()
{
    // TODO - Put the thread's "main" Initialization HERE
	VDK::MessageID input_msg;
	VDK::MessageID output_msg;

	// For payloads
	int      type;
	unsigned size;
	void    *p_input;
	void    *p_output;
    
    while (1)
    {
        // TODO - Put the thread's "main" body HERE
        input_msg = VDK::PendMessage(INPUT_DATA_CHANNEL, 0);
		VDK::GetMessagePayload(input_msg, &type, &size, &p_input);
        
        output_msg = VDK::PendMessage(OUTPUT_DATA_CHANNEL, 0);
        VDK::GetMessagePayload(output_msg, &type, &size, &p_output);
        
        //main signal processing
        
		//AttenuateBuffer16to32((short*)p_input,(int*)p_output,SAMPLEPAIRS_PER_BUFFER, 0x00800080);        
		AttenuateBuffer16to32((short*)p_input,(int*)p_output,SAMPLEPAIRS_PER_BUFFER, volume_value);        
        
        VDK::PostMessage(kbinput_thread, input_msg, INPUT_DATA_BACKCHANNEL);
        VDK::PostMessage(kboutput_thread, output_msg, OUTPUT_DATA_BACKCHANNEL);

        
    }

    // TODO - Put the thread's exit from "main" HERE
	// A thread is automatically Destroyed when it exits its run function
}

/******************************************************************************
 *  main_thread Error Handler
 */
 
int
main_thread::ErrorHandler()
{
    /* TODO - Put this thread's error handling code HERE */

    /* The default ErrorHandler (called below)  raises
     * a kernel panic and stops the system */
    return (VDK::Thread::ErrorHandler());
}

/******************************************************************************
 *  main_thread Constructor
 */
 
main_thread::main_thread(VDK::Thread::ThreadCreationBlock &tcb)
    : VDK::Thread(tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    // TODO - Put code to be executed when this thread has just been created HERE

}

/******************************************************************************
 *  main_thread Destructor
 */
 
main_thread::~main_thread()
{
    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */

    // TODO - Put code to be executed just before this thread is destroyed HERE

}

/******************************************************************************
 *  main_thread Externally Accessible, Pre-Constructor Create Function
 */
 
VDK::Thread*
main_thread::Create(VDK::Thread::ThreadCreationBlock &tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    	return new (tcb) main_thread(tcb);
}

/* ========================================================================== */
