/* =============================================================================
 *
 *  Description: This is a C++ implementation for Thread output_write
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

#include "output_write.h"
#include <new>
#include <stdio.h>
#include "msg.h"

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

typedef int Output_SampleWord;
#define SAMPLEPAIRS_PER_BUFFER 48


/******************************************************************************
 *  output_write Run Function (output_write's main{})
 */
 
void
output_write::Run()
{
    // TODO - Put the thread's "main" Initialization HERE
	VDK::DeviceDescriptor dd = VDK::OpenDevice(kDAC0, "W24"); // open for writing
    
	void *p_outBuffer1 = new Output_SampleWord[2*SAMPLEPAIRS_PER_BUFFER];    
    void *p_outBuffer2 = new Output_SampleWord[2*SAMPLEPAIRS_PER_BUFFER];    
    unsigned char current_outbuffer = 1;
    
    
 	VDK::MessageID omsg1 = VDK::CreateMessage(1, SAMPLEPAIRS_PER_BUFFER, p_outBuffer1);   
 	VDK::MessageID omsg2 = VDK::CreateMessage(1, SAMPLEPAIRS_PER_BUFFER, p_outBuffer2);   
 	
    VDK::SyncWrite(dd, (char*) p_outBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(Output_SampleWord), 0);

    while (1)
    {
        // TODO - Put the thread's "main" body HERE
		if(1 == current_outbuffer)
		{
        	VDK::SyncWrite(dd, (char*) p_outBuffer2, SAMPLEPAIRS_PER_BUFFER*2*sizeof(Output_SampleWord), 0);
        	current_outbuffer = 2;
        	VDK::PostMessage(kmt, omsg1, OUTPUT_DATA_CHANNEL);
        	omsg1 = VDK::PendMessage(OUTPUT_DATA_BACKCHANNEL, 0);
		}
		else
		{
        	VDK::SyncWrite(dd, (char*) p_outBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(Output_SampleWord), 0);
        	current_outbuffer = 1;
        	VDK::PostMessage(kmt, omsg2, OUTPUT_DATA_CHANNEL);
        	omsg2 = VDK::PendMessage(OUTPUT_DATA_BACKCHANNEL, 0);
		}

        // Use a "break" instruction to exit the "while (1)" loop
    }

    // TODO - Put the thread's exit from "main" HERE
	// A thread is automatically Destroyed when it exits its run function
}

/******************************************************************************
 *  output_write Error Handler
 */
 
int
output_write::ErrorHandler()
{
    /* TODO - Put this thread's error handling code HERE */
    
	VDK::SystemError err=VDK::GetLastThreadError();
    /* The default ErrorHandler (called below)  raises
     * a kernel panic and stops the system */
    return (VDK::Thread::ErrorHandler());
}

/******************************************************************************
 *  output_write Constructor
 */
 
output_write::output_write(VDK::Thread::ThreadCreationBlock &tcb)
    : VDK::Thread(tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    // TODO - Put code to be executed when this thread has just been created HERE

}

/******************************************************************************
 *  output_write Destructor
 */
 
output_write::~output_write()
{
    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */

    // TODO - Put code to be executed just before this thread is destroyed HERE

}

/******************************************************************************
 *  output_write Externally Accessible, Pre-Constructor Create Function
 */
 
VDK::Thread*
output_write::Create(VDK::Thread::ThreadCreationBlock &tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    	return new (tcb) output_write(tcb);
}

/* ========================================================================== */
