/* =============================================================================
 *
 *  Description: This is a C++ implementation for Thread uart_control
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

#include "uart_control.h"
#include <new>
#include "globals.h"
#include "pll.h"
#include <math.h>

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

/******************************************************************************
 *  uart_control Run Function (uart_control's main{})
 */
 
void
uart_control::Run()
{
    // TODO - Put the thread's "main" Initialization HERE
	VDK::MessageID msg = VDK::CreateMessage(0, 0, 0);   
	
	unsigned char value = 8;
    while (1)
    {
        // TODO - Put the thread's "main" body HERE
        
		float pDecibels = (float)value;
	    float divisor = powf(2, pDecibels/6.0);
	    int scaledDivisor = 0x00FF & (int)(0x0080 / divisor);
	    
	    scaledDivisor = 0xFFFF & (1<<value);
	    volume_value = scaledDivisor | (scaledDivisor << 16);
        
		 VDK::PendSemaphore(kuart0_data_arrived,0);
		 
		 if(value < 20)
		 {
		 	if( '+' == uart0_value)
		 		value++;
		 }
		 
		 if(0 != value)
		 {
		 	if('-' == uart0_value)
		 		value--;
		 }
		 
        // Use a "break" instruction to exit the "while (1)" loop
    }

    // TODO - Put the thread's exit from "main" HERE
	// A thread is automatically Destroyed when it exits its run function
}

/******************************************************************************
 *  uart_control Error Handler
 */
 
int
uart_control::ErrorHandler()
{
    /* TODO - Put this thread's error handling code HERE */

    /* The default ErrorHandler (called below)  raises
     * a kernel panic and stops the system */
    return (VDK::Thread::ErrorHandler());
}

/******************************************************************************
 *  uart_control Constructor
 */
 
uart_control::uart_control(VDK::Thread::ThreadCreationBlock &tcb)
    : VDK::Thread(tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    // TODO - Put code to be executed when this thread has just been created HERE
    Init_PLL();
     
#define BAUD_RATE_115200     (65)
#define MAX_TEST_CHARS        5000
    
    volatile int temp;
    
    // set FERF registers
#if (__SILICON_REVISION__ < 0x0001) // Workaround silicon anomaly 05000212
    temp = *pPORTF_FER; //--possibly anomaly 05000157?
    *pPORTF_FER = 0x0003;
#endif
    *pPORTF_FER = 0x0003;
    
    // Configure UART0 RX and UART0 TX pins  
#if (__SILICON_REVISION__ < 0x0001) // Workaround silicon anomaly 05000212
    temp = *pPORT_MUX; //--possibly anomaly 05000157?
    *pPORT_MUX = 0;
#endif
    *pPORT_MUX = 0;
 
/*****************************************************************************
 *
 *  First of all, enable UART clock.
 *
 ****************************************************************************/
    *pUART0_GCTL = UCEN;
    
/*****************************************************************************
 *
 *  Read period value and apply formula:  DL = PERIOD / 16 / 8
 *  Write result to the two 8-bit DL registers (DLH:DLL).
 *
 ****************************************************************************/
    *pUART0_LCR = DLAB | WLS(8);
    *pUART0_DLL = BAUD_RATE_115200;
    *pUART0_DLH = (BAUD_RATE_115200 >> 8);
    
/*****************************************************************************
 *
 *  Clear DLAB again and set UART frame to 8 bits, no parity, 1 stop bit.
 *  This may differ in other scenarious.
 *
 ****************************************************************************/
    *pUART0_LCR = WLS(8);
     
/*****************************************************************************
 *
 *  Finally enable interrupts inside UART module, by setting proper bits
 *  in the IER register. It is good programming style to clear potential
 *  UART interrupt latches in advance, by reading RBR, LSR and IIR.
 *
 *  Setting the ETBEI bit automatically fires a TX interrupt request.
 *
 ****************************************************************************/     
    temp = *pUART0_RBR;
    temp = *pUART0_LSR;
    temp = *pUART0_IIR;
    
    *pUART0_IER = ERBFI;

    *pSIC_IMASK |= 0x800;     
     
}

/******************************************************************************
 *  uart_control Destructor
 */
 
uart_control::~uart_control()
{
    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */

    // TODO - Put code to be executed just before this thread is destroyed HERE

}

/******************************************************************************
 *  uart_control Externally Accessible, Pre-Constructor Create Function
 */
 
VDK::Thread*
uart_control::Create(VDK::Thread::ThreadCreationBlock &tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    	return new (tcb) uart_control(tcb);
}

/* ========================================================================== */
