/* =============================================================================
 *
 *  Description: This is a C implementation for Thread main
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

/* Get access to any of the VDK features & datatypes used */
#include "main.h"
#include <stdio.h>
#include "globals.h"
#include "pll.h"

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

void
main_RunFunction(void **inPtr)
{
    /* Put the thread's "main" Initialization HERE */
	int ii=0;
    while (1)
    {
        /* Put the thread's "main" body HERE */
		VDK_PendSemaphore(kuart0_data_arrived,0);
 		printf("ii = %d,uart0_value = %d\n",ii,uart0_value);
        ii++;
        /* Use a "break" instruction to exit the "while (1)" loop */
    }

    /* Put the thread's exit from "main" HERE */
    /* A thread is automatically Destroyed when it exits its run function */
}

int
main_ErrorFunction(void **inPtr)
{

    /* TODO - Put this thread's error handling code HERE */

      /* The default ErrorHandler goes to KernelPanic */

	VDK_CThread_Error(VDK_GetThreadID());
	return 0;
}

void
main_InitFunction(void **inPtr, VDK_ThreadCreationBlock const *pTCB)
{
    /* Put code to be executed when this thread has just been created HERE */

    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */
     
     Init_PLL();
     
#define BAUD_RATE_115200     (65)
#define MAX_TEST_CHARS        5000
    
    volatile int temp;
    
    // set FERF registers
#if (__SILICON_REVISION__ < 0x0001) // Workaround silicon anomaly 05000212
    temp = *pPORTF_FER; //--possibly anomaly 05000157?
    *pPORTF_FER = 0x0003;
#endif
    *pPORTF_FER = 0x0003;
    
    // Configure UART0 RX and UART0 TX pins  
#if (__SILICON_REVISION__ < 0x0001) // Workaround silicon anomaly 05000212
    temp = *pPORT_MUX; //--possibly anomaly 05000157?
    *pPORT_MUX = 0;
#endif
    *pPORT_MUX = 0;
 
/*****************************************************************************
 *
 *  First of all, enable UART clock.
 *
 ****************************************************************************/
    *pUART0_GCTL = UCEN;
    
/*****************************************************************************
 *
 *  Read period value and apply formula:  DL = PERIOD / 16 / 8
 *  Write result to the two 8-bit DL registers (DLH:DLL).
 *
 ****************************************************************************/
    *pUART0_LCR = DLAB | WLS(8);
    *pUART0_DLL = BAUD_RATE_115200;
    *pUART0_DLH = (BAUD_RATE_115200 >> 8);
    
/*****************************************************************************
 *
 *  Clear DLAB again and set UART frame to 8 bits, no parity, 1 stop bit.
 *  This may differ in other scenarious.
 *
 ****************************************************************************/
    *pUART0_LCR = WLS(8);
     
/*****************************************************************************
 *
 *  Finally enable interrupts inside UART module, by setting proper bits
 *  in the IER register. It is good programming style to clear potential
 *  UART interrupt latches in advance, by reading RBR, LSR and IIR.
 *
 *  Setting the ETBEI bit automatically fires a TX interrupt request.
 *
 ****************************************************************************/     
    temp = *pUART0_RBR;
    temp = *pUART0_LSR;
    temp = *pUART0_IIR;
    
    *pUART0_IER = ERBFI;

    *pSIC_IMASK |= 0x800;     
     
}

void
main_DestroyFunction(void **inPtr)
{
    /* Put code to be executed when this thread is destroyed HERE */

    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */
}

/* ========================================================================== */
