/* =============================================================================
 *
 *  Description: This is a C++ implementation for Thread main_thread
 *
 * -----------------------------------------------------------------------------
 *  Comments:
 *
 * ===========================================================================*/

#include "main_thread.h"
#include <new>
#include <stdio.h>
#include "pll.h"

#pragma file_attr("OS_Component=Threads")
#pragma file_attr("Threads")

#define SAMPLEPAIRS_PER_BUFFER 480
typedef short SampleWord; //16 bit AD



/******************************************************************************
 *  main_thread Run Function (main_thread's main{})
 */
 

void
main_thread::Run()
{
	unsigned char current_buffer=1;
	int max_value = 0;
	unsigned int ii;
	int cntr = 0;
	int temp;
	SampleWord *p;
	
    // TODO - Put the thread's "main" Initialization HERE
	VDK::DeviceDescriptor dd = VDK::OpenDevice(kADC0, "R16"); // open for reading

	void *pBuffer1 = new SampleWord[2*SAMPLEPAIRS_PER_BUFFER];
	void *pBuffer2 = new SampleWord[2*SAMPLEPAIRS_PER_BUFFER];
	
	void *pBuffer;
	
	VDK::SyncRead(dd, (char*) pBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
		
    while (1)
    {
        // TODO - Put the thread's "main" body HERE
        if(1 == current_buffer)
        {
        	VDK::SyncRead(dd, (char*) pBuffer2, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
        	current_buffer = 2;
        	pBuffer = pBuffer1;
        }
        else
        {
        	VDK::SyncRead(dd, (char*) pBuffer1, SAMPLEPAIRS_PER_BUFFER*2*sizeof(SampleWord), 0);
        	current_buffer = 1;
        	pBuffer = pBuffer2;
        } 
        
        
        
        p = (SampleWord*)(pBuffer);
		
		//DEBUG -- BEGIN
		cntr++;		
		if(50 == cntr)
		{
			cntr = 0;
		}
		
		
       
       // Use a "break" instruction to exit the "while (1)" loop
    }

    // TODO - Put the thread's exit from "main" HERE
	// A thread is automatically Destroyed when it exits its run function
}

/******************************************************************************
 *  main_thread Error Handler
 */
 
int
main_thread::ErrorHandler()
{
    /* TODO - Put this thread's error handling code HERE */

    /* The default ErrorHandler (called below)  raises
     * a kernel panic and stops the system */
    return (VDK::Thread::ErrorHandler());
}

/******************************************************************************
 *  main_thread Constructor
 */
 
main_thread::main_thread(VDK::Thread::ThreadCreationBlock &tcb)
    : VDK::Thread(tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    // TODO - Put code to be executed when this thread has just been created HERE
    Init_PLL();

}

/******************************************************************************
 *  main_thread Destructor
 */
 
main_thread::~main_thread()
{
    /* This routine does NOT run in the thread's context.  Any VDK API calls
     *   should be performed at the end of "Run()."
     */

    // TODO - Put code to be executed just before this thread is destroyed HERE

}

/******************************************************************************
 *  main_thread Externally Accessible, Pre-Constructor Create Function
 */
 
VDK::Thread*
main_thread::Create(VDK::Thread::ThreadCreationBlock &tcb)
{
    /* This routine does NOT run in new thread's context.  Any non-static thread
     *   initialization should be performed at the beginning of "Run()."
     */

    	return new (tcb) main_thread(tcb);
}

/* ========================================================================== */
